// XISLSpeechInputTag.cpp: CXISLSpeechInputTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLSpeechInputTag.h"
#include "XISLVar.h"
#include "XISLDialogTag.h"
#include "XISLExchangeTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLSpeechInputTag::CXISLSpeechInputTag()
{
	m_nTagType = ID_TAG_INPUT;
	m_nInputType = ID_INPUTTYPE_SPEECH;
	m_nEvent = ID_INPUTEVENT_SPEECHRECO;
	m_nBmpID = IDB_SPEECH;
}

CXISLSpeechInputTag::~CXISLSpeechInputTag()
{

}

CXISLSpeechInputTag::CXISLSpeechInputTag(const CXISLSpeechInputTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_nInputType = cpXISL.m_nInputType;
	m_nEvent = cpXISL.m_nEvent;
	m_strMatch = cpXISL.m_strMatch;
	m_strGrmFile = cpXISL.m_strGrmFile;
}

CXISLSpeechInputTag& CXISLSpeechInputTag::operator=(const CXISLSpeechInputTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_nInputType = cpXISL.m_nInputType;
		m_nEvent = cpXISL.m_nEvent;
		m_strMatch = cpXISL.m_strMatch;
	}
	return *this;
}

BOOL CXISLSpeechInputTag::SetAttribute(LPCTSTR lpszGrmFile,LPCTSTR lpszReturn)
{
	m_strGrmFile = lpszGrmFile;

	CString strReturn = lpszReturn;
	if(strReturn.IsEmpty())
		return TRUE;

	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pParentTag->GetParentExcTag();
	BOOL bFin = FALSE;
	int nIndex;
	if(!strReturn.IsEmpty())
	{
		while(!bFin)
		{
			CString strVarName;
			nIndex = strReturn.Find(',');
			if(nIndex == -1)
			{
				strVarName = strReturn;
				bFin = TRUE;
			}
			else
				strVarName = strReturn.Left(nIndex);

			CXISLVar *pVar = NULL;
			pVar = pExcItem->m_pLocalVar->FindVarWithParent(strVarName);
			if(pVar == NULL)
			{
				pVar = new CXISLVar;
				if(pVar->SetAttribute(strVarName,"",FALSE,FALSE) != 0)
				{
					delete pVar;
					return FALSE;
				}
				pExcItem->m_pLocalVar->RegistVar(pVar);
			}

			m_ReturnVarList.AddTail(pVar);
			pVar->ReferCount(TRUE);
//			pExcItem->m_pLocalVar->ReferVar(pVar->GetVarName(),TRUE);
			strReturn.Delete(0,nIndex+1);
		}
	}

	return TRUE;
}

LPCTSTR CXISLSpeechInputTag::GetXISLString()
{
	CString strInputType = XISL_INPUTTYPE[m_nInputType];

	m_strXISL = "<input type=\"" + strInputType;
	m_strXISL += "\" event=\"";
	m_strXISL += XISL_INPUTEVENT[m_nEvent];

	m_strXISL += "\" match=\"";
	m_strXISL += GetMatch();

	CString strReturn;
	POSITION pos = m_ReturnVarList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_ReturnVarList.GetNext(pos);
		strReturn += pVar->GetVarName();
		if(pos)
			strReturn += ",";
	}

	if(!strReturn.IsEmpty())
	{
		m_strXISL += "\" return=\"";
		m_strXISL += strReturn;
	}
	m_strXISL += "\" />\r\n";

	return m_strXISL;
}

LPCTSTR CXISLSpeechInputTag::GetMatch()
{
	return m_strGrmFile;
/*
	m_strMatch = "http://www.vox.tutkie.tut.ac.jp/~adachi/IB/";
	if(m_strGrmFile.Find("http://") != -1)
	{
		m_strGrmFile.Replace("\\","/");
		int nIndex = m_strGrmFile.ReverseFind('/')+1;
		m_strGrmFile = m_strGrmFile.Right(m_strGrmFile.GetLength()-nIndex);
	}
	m_strMatch += m_strGrmFile + "#";
	m_strMatch += m_strGrmRule.Right(m_strGrmRule.GetLength()-1);
	return m_strMatch;
	*/
}